﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Magazyny" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="System.Collections.Generic" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport marży wg towarów</title>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
    <script runat="server">
        public enum SortowanieWedług { WgKoduTowaru, WgNazwyTowaru, WgWartościMalejąco }

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            SortowanieWedług sortujWedług = SortowanieWedług.WgNazwyTowaru;

            [DefaultWidth(50)]
            [Priority(10)]
            public SortowanieWedług SortujWedług {
                get { return sortujWedług; }
                set {
                    sortujWedług = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            int pierwszych = 0;

            [Priority(20)]
            public int Pierwszych {
                get { return pierwszych; }
                set { pierwszych = value; }
            }

            public bool IsReadOnlyPierwszych() {
                return SortujWedług != SortowanieWedług.WgWartościMalejąco;
            }

			private bool _raportowacKwpz = true;

			private bool _ignorujZal = false;

			[Soneta.Tools.Priority(30)]
			[Soneta.Types.Caption(@"Ignoruj zaliczkowe")]
			public bool IgnorujZaliczkowe
			{
				get
				{
					return this._ignorujZal;
				}
				set
				{
					this._ignorujZal = value;
					OnChanged(EventArgs.Empty);
				}
			}

			[Soneta.Tools.Priority(40)]
			public bool IgnorujDuplikaty
			{
				get
				{
					return true;
				}
			}

			[Soneta.Tools.Priority(50)]
			[Caption("Korekty kosztu (KWPZ)")]
			public bool RaportowacKwpz
			{
				get
				{
					return true;
				}
			}
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total {
            readonly Towar towar;
            decimal znetto;
            decimal snetto;
            decimal zysk;

            public Total(Towar towar) {
                this.towar = towar;
            }

            private Percent NarzutProcent(decimal wartośćZakupu, decimal marża) {
                    if(Soneta.Tools.Math.IsBlank(wartośćZakupu)) return Percent.Blank;
                    if(wartośćZakupu == 0) return Percent.Blank;
                    if(wartośćZakupu < 0) return new Percent((marża / wartośćZakupu) * (-1));
                    return new Percent(marża / wartośćZakupu);
            }

            private Percent MarżaProcent(decimal wartośćZakupu, decimal marża) {
                    if(Soneta.Tools.Math.IsBlank(wartośćZakupu)) return Percent.Blank;
                    if(wartośćZakupu + marża == 0) return Percent.Blank;
                    if(wartośćZakupu + marża < 0) return new Percent((marża / (wartośćZakupu + marża)) * (-1));
                    return new Percent(marża / (wartośćZakupu + marża));
            }

            SumaPozycjiWorker spw = new SumaPozycjiWorker();

            public void Add(PozycjaDokHandlowego pozycja) {
                spw.Pozycja = pozycja;
                decimal wzakupu = pozycja.WartośćWCenieZakupuBufor;
                decimal wsprzedazy = spw.Netto;
                decimal marza = wsprzedazy - wzakupu;
                znetto += wzakupu;
                snetto += wsprzedazy;
                zysk += marza;
            }

            internal void AddKwpz(PozycjaDokHandlowego pozycja) {
                decimal wzakupu = pozycja.WartośćWCenieZakupuBufor;
                znetto += wzakupu;
                zysk = snetto - znetto;
            }

            public Towar Towar {
                get { return towar; }
            }

            public decimal ZNetto {
                get { return znetto; }
            }

            public decimal SNetto {
                get { return snetto; }
            }

            public decimal Zysk {
                get { return zysk; }
            }

            public Percent NarzutProc {
                get {
                    if (znetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / znetto);
                }

            }

            public Percent MarzaProc {
                get {
                    if (snetto == 0) return Percent.Blank;
                    else
                        return new Percent(zysk / snetto);
                }
            }

        }

        class NazwaComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Towar == null ? "" : t1.Towar.Nazwa;
                string s2 = t2.Towar == null ? "" : t2.Towar.Nazwa;
                return s1.CompareTo(s2);
            }
        }

        class KodComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                string s1 = t1.Towar == null ? "" : t1.Towar.Kod;
                string s2 = t2.Towar == null ? "" : t2.Towar.Kod;
                return s1.CompareTo(s2);
            }
        }

        class WartośćComparer : IComparer {
            public int Compare(object obj1, object obj2) {
                Total t1 = (Total)obj1;
                Total t2 = (Total)obj2;
                if (t1.ZNetto < t2.ZNetto) return 1;
                if (t1.ZNetto > t2.ZNetto) return -1;
                return 0;
            }
        }
        Row[] rows;
        protected void dc_ContextLoad(object sender, EventArgs e) {

			sIgnorujZaliczkowe.Visible = Parametry.IgnorujZaliczkowe;

            rows = (Row[])dc[typeof(Row[])];
            ListWithView lwv = new ListWithView(rows, HandelModule.GetInstance(dc.Session).DokHandlowe.WgDaty);

            Dictionary<Towar, Total> result = new Dictionary<Towar, Total>();

            foreach (DokumentHandlowy dokh in lwv) {
                if(dokh.Anulowany) continue;
                if(dokh.Definicja.DuplikatWartosci) continue;
                if(dokh.Kontrahent == null) continue;
                if(dokh.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę &&
                   Parametry.IgnorujZaliczkowe) continue;
                System.Diagnostics.Trace.Write(dokh, "Progress");
                foreach(PozycjaDokHandlowego poz in dokh.Pozycje) {
                    Total t = null;
                    result.TryGetValue(poz.Towar, out t);
                    if(t == null) {
                        t = new Total(poz.Towar);
                        result.Add(t.Towar, t);
                    }
                    t.Add(poz);
                }
            }

       			if (this.Parametry.RaportowacKwpz)
      			{
			      	this.LoadKWPZ( result );
			      }

            ArrayList lista = new ArrayList(result.Values);
            switch (Parametry.SortujWedług) {
                case SortowanieWedług.WgKoduTowaru:
                    lista.Sort(new KodComparer());
                    break;
                case SortowanieWedług.WgNazwyTowaru:
                    lista.Sort(new NazwaComparer());
                    break;
                case SortowanieWedług.WgWartościMalejąco:
                    lista.Sort(new WartośćComparer());
                    if (Parametry.Pierwszych > 0 && lista.Count > Parametry.Pierwszych)
                        lista.RemoveRange(Parametry.Pierwszych, lista.Count - Parametry.Pierwszych);
                    break;
            }
            Grid.DataSource = lista;

        }

        void LoadKWPZ( Dictionary<Towar, Total> result )
        {
            var hm = HandelModule.GetInstance(dc);
            var magazyn = (Soneta.Magazyny.Magazyn)dc[typeof(Soneta.Magazyny.Magazyn)];
            var pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)
                dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            var vw = new SubTable( hm.PozycjeDokHan.WgDaty , pars.Okres).CreateView();
            vw.Condition &= new RowCondition.And(
                new FieldCondition.Equal("Dokument.Definicja", hm.DefDokHandlowych.KorektaPZWZ),
                new FieldCondition.NotEqual("Dokument.Stan", StanDokumentuHandlowego.Anulowany));
            if (magazyn != null)
            {
                vw.Condition &= new FieldCondition.Equal("Dokument.Magazyn", magazyn);				
            }

            vw.FilterCondition += (_, e) => e.Accepted &= Filter2(((PozycjaDokHandlowego) e.Row).Dokument);

            foreach (PozycjaDokHandlowego i in vw)
            {
                Total t;
                if (!result.TryGetValue( i.Towar, out t ))
                {
                    t = new Total( i.Towar );
                    result.Add( t.Towar, t );
                }

                t.AddKwpz( i );
            }
        }

        static bool Filter2( DokumentHandlowy dok )
        {
            foreach (DokumentHandlowy wz in dok.Nadrzędne)
            {
                if (wz.Definicja ==
                    dok.Module.DefDokHandlowych.KorektaPZWZ)
                {
                    if (Filter2( wz )) return true;
                }
                else if (wz.KierunekMagazynu == KierunekPartii.Rozchód)
                {
                    if (( KategoriaHandlowa.HandelPierwszy <=
                            wz.Kategoria &&
                            wz.Kategoria <=
                            KategoriaHandlowa.HandelOstatni ) ||
                        wz.DokumentyHandlowe.Length > 0) return true;
                }
            }

            return false;
        }

</script>

<body>
    <form id="Form1" method="post" runat="server">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Raport marży wg towarów|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}</STRONG>"
            runat="server" DataMember3="DokHandloweViewInfo+WParams.Magazyn" DataMember2="DokHandloweViewInfo+WParams.Okres">
        </eb:ReportHeader>
		<font face="Verdana" size="2">Raport nie uwzględnia duplikatów.</font>
		<br />
        <ea:Section runat="server" ID="sIgnorujZaliczkowe">
			<font face="Verdana" size="2">Raport nie uwzględnia faktur zaliczkowych.</font>
			<br />
		</ea:Section>
        <font face="Verdana" size="2">Raport uwzględnia korekty kosztu (KWPZ).</font>
        <br />
        <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            FooterBorder="Single" ShowSum="MoreThenOne">
            <Columns>
                <ea:GridColumn ID="GridColumn1" Width="4" Align="Right" DataMember="#" Caption="Lp."
                    runat="server">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn2" runat="server" Caption="Kod" DataMember="Towar.Kod" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="GridColumn8" DataMember="Towar.Nazwa" runat="server" Caption="Towar" Total="Info" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn ID="zakup" Width="13" Align="Right" Caption="Wartość~Zakupu" runat="server"
                    DataMember="ZNetto" Total="Sum" Format="{0:n}">
                </ea:GridColumn>
                <ea:GridColumn ID="sprzedaz" Width="13" Align="Right" Caption="Wartość~Sprzedaży" runat="server"
                    DataMember="SNetto" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="zysk" Width="13" Align="Right" Caption="Wartość~Marża"
                    runat="server" DataMember="Zysk" Format="{0:n}" Total="Sum">
                </ea:GridColumn>
                <ea:GridColumn ID="narzut" Width="10" Align="Right" Caption="Narzut %" runat="server"
                    DataMember="NarzutProc">
                </ea:GridColumn>
                <ea:GridColumn ID="marza" Width="10" Align="Right" Caption="Marża %" runat="server"
                    DataMember="MarzaProc">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
        </eb:ReportFooter>
    </form>
</body>
</html>
